package model;

import java.util.Observable;

public class ProxyPezzo implements IPezzo, Comparable<ProxyPezzo> {

	IPezzo pezzo;

	public ProxyPezzo(IPezzo pezzo) {
		this.pezzo = pezzo;
	}

	@Override
	public String getCodeID() {
		return pezzo.getCodeID();
	}

	@Override
	public void setCodeID(String codeID) {
		pezzo.setCodeID(codeID);

	}

	@Override
	public int getDate() {
		return pezzo.getDate();
	}

	@Override
	public void setDate(int date) {
		pezzo.setDate(date);

	}

	@Override
	public String getSala() {
		return pezzo.getSala();
	}

	@Override
	public void setSala(String sala) {
		pezzo.setSala(sala);

	}

	@Override
	public String getDescription() {
		return pezzo.getDescription();
	}

	@Override
	public void setDescription(String description) {
		pezzo.setDescription(description);

	}

	public int compareTo(ProxyPezzo prpezzo) {
		if (pezzo.getSala().compareTo(prpezzo.getSala()) != 0) {
			return pezzo.getSala().compareTo(prpezzo.getSala());
		} else if (Integer.compare(pezzo.getDate(), prpezzo.getDate()) != 0) {
			return Integer.compare(pezzo.getDate(), prpezzo.getDate());
		} else if (pezzo.getCodeID().compareToIgnoreCase(prpezzo.getCodeID()) != 0) {
			return pezzo.getCodeID().compareToIgnoreCase(prpezzo.getCodeID());
		}
		return 0;
	}

}
